/*-----------------------------------------------------------------------------
	{WinMain.h]

	Copyright (C) 2004 Ki

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-----------------------------------------------------------------------------*/
#ifndef WINMAIN_H_INCLUDED
#define WINMAIN_H_INCLUDED

#include "TypeDefs.h"


enum UserDefinedWM
{
	WM_SET_FULLSCREEN_WS = WM_APP,
	WM_SET_NORMAL_WS,
	WM_MEMED_CLOSE,
};

/* j[R}h 100 ` */
enum MenuCommand
{
	WM_TRACE_1_STEP = 100,
	WM_TRACE_10_STEP,
	WM_TRACE_100_STEP,
	WM_TRACE_1000_STEP,
	WM_TRACE_10000_STEP,
	WM_TRACE_1_FRAME,
	WM_TRACE_10_FRAME,
	WM_TRACE_100_FRAME,
	WM_OPEN_FILE,
	WM_RESET_EMULATOR,
	WM_RUN_EMULATOR,
	WM_STOP_EMULATOR,
	WM_LOAD_STATE,
	WM_SAVE_STATE,
	WM_RECORD_GAMEPLAY,
	WM_PLAYBACK_GAMEPLAY,
	WM_CDROM_LOG,
	WM_HDWR_LOG,

	WM_SCREEN_X1,
	WM_SCREEN_X2,
	WM_SCREEN_X3,
	WM_SCREEN_X4,

	WM_INPUT_TWO_BUTTON_PAD,
	WM_INPUT_SIX_BUTTON_PAD,
	WM_INPUT_MOUSE,
	WM_INPUT_MULTI_TAP,
	WM_INPUT_MB128,

	WM_INPUT_CONFIGURE_PAD1,
	WM_INPUT_CONFIGURE_PAD2,
	WM_INPUT_CONFIGURE_PAD3,
	WM_INPUT_CONFIGURE_PAD4,
	WM_INPUT_CONFIGURE_PAD5,

	WM_SCREEN_FULLSCREEN,
	WM_SCREEN_STRETCHED,
	WM_SCREEN_SCANLINED,
	WM_SCREEN_HWACCEL,
	WM_SCREEN_SYNC_VBLANK,

	WM_AUDIO_SR11025,
	WM_AUDIO_SR22050,
	WM_AUDIO_SR32000,
	WM_AUDIO_SR44100,
	WM_AUDIO_SR48000,
	WM_AUDIO_SR64000,
	WM_AUDIO_SR88200,		/* not supported */
	WM_AUDIO_SR96000,		/* not supported */

	WM_AUDIO_SB2048,
	WM_AUDIO_SB2304,
	WM_AUDIO_SB2560,
	WM_AUDIO_SB2816,
	WM_AUDIO_SB3072,
	WM_AUDIO_SB3328,
	WM_AUDIO_SB3584,
	WM_AUDIO_SB3840,
	WM_AUDIO_SB4096,

	WM_AUDIO_SETVOLUME,

	WM_EXIT,

	WM_SAVE_BMP,
};


extern int		__main__(int argc, char** argv);


const HINSTANCE	WINMAIN_GetHInstance();
const HWND		WINMAIN_GetHwnd();

void
WINMAIN_SetFullScreenWindow(
	Sint32		width,
	Sint32		height);
void
WINMAIN_SetNormalWindow(
	Sint32		width,
	Sint32		height);

void
WINMAIN_SetCaption(
	const char*		pCaption);

Uint32
WINMAIN_ShowCursor(
	BOOL		bShow);

void
WINMAIN_GetMousePos(
	Sint32*		x,
	Sint32*		y);


#endif /* WINMAIN_H_INCLUDED */
